﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace r13.Engines
{
    public class XSLTViewEngine : VirtualPathProviderViewEngine
    {
        public XSLTViewEngine()
        {
            ViewLocationFormats = PartialViewLocationFormats = new[] { 
            "~/Views/{1}/{0}.xslt", 
            "~/Views/Shared/{0}.xslt", 
        };

            AreaViewLocationFormats = AreaPartialViewLocationFormats = new[] { 
            "~/Areas/{2}/Views/{1}/{0}.xslt",
            "~/Areas/{2}/Views/Shared/{0}.xslt", 
        };
        }

        protected override IView CreateView(ControllerContext controllerContext,
                                            string viewPath, string masterPath)
        {
            // Ten silnik widoku nie obsługuje stron wzorcowych, 
            // więc możemy zignorować żąania użycia strony wzorcowej 
            return new XSLTView(controllerContext, viewPath);
        }

        protected override IView CreatePartialView(ControllerContext controllerContext,
                                                   string partialPath)
        {
            // Ten silnik widoku nie musi odróżniać widoków od widoków częściowych 
            // więc po prostu wywołujemy zwykłą metodę CreateView()
            return CreateView(controllerContext, partialPath, null);
        }
    }

}